<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('activation_codes', function (Blueprint $table) {
            $table->string('owner_name')->after('code');
            $table->enum('duration_type', ['hour', 'day'])->after('owner_name');
            $table->integer('duration_value')->after('duration_type');
        });
    }

    public function down(): void
    {
        Schema::table('activation_codes', function (Blueprint $table) {
            $table->dropColumn([
                'owner_name',
                'duration_type',
                'duration_value'
            ]);
        });
    }
};

