<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Dashboard\ActivationCodeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// الصفحة الرئيسية
Route::get('/', function () {
    if (Auth::check()) {
        return redirect('/dashboard/codes');
    }
    return redirect('/login');
});

// Dashboard (محمي)
Route::middleware('auth')->group(function () {

    Route::get('/dashboard/codes', [ActivationCodeController::class, 'index'])
        ->name('dashboard.codes');

    Route::post('/dashboard/codes', [ActivationCodeController::class, 'store']);
    Route::post('/dashboard/codes/{id}/disable', [ActivationCodeController::class, 'disable']);
});

// Auth (Login / Register / Logout)
require __DIR__.'/auth.php';

